using gov.va.med.vbecs.Common;
using System;
using System.Collections.Generic;
using System.Linq;

namespace gov.va.med.vbecs.BOL
{
    /// <summary>
    /// PendingSpecimenXMatchModel
    /// </summary>
    public class PendingSpecimenXMatchModel : PendingTestModel, IPendingSpecimenTestModel, IPendingBloodUnitTestModel
    {
        /// <summary>
        /// BloodUnitId
        /// </summary>
        public string BloodUnitId { get; set; }
        /// <summary>
        /// BloodUnitModel for Product Code
        /// </summary>
        public BloodUnitModel BloodUnitModel { get; set; }
        /// <summary>
        /// PatientSpecimenGuid
        /// </summary>
        public Guid PatientSpecimenGuid { get; set; }
        /// <summary>
        /// SpecimenUid
        /// </summary>
        public string SpecimenUid { get; set; }
        /// <summary>
        /// PatientGuid
        /// </summary>
        public Guid PatientGuid { get; set; }
        /// <summary>
        /// OrderedUnitModel
        /// </summary>
        public OrderedUnitModel OrderedUnitModel { get; set; }
        /// <summary>
        /// OrderedTestGuid
        /// </summary>
        public Guid? OrderedTestGuid { get; set; }
        /// <summary>
        /// OrderedComponentGuid
        /// </summary>
        public Guid? OrderedComponentGuid { get; set; }
        /// <summary>
        /// OrderedTest
        /// </summary>
        public OrderedTest OrderedTest { get; set; }
        /// <summary>
        /// SpecimenResultSetGuid
        /// </summary>
        public Guid ResultSetGuid { get; set; }
        /// <summary>
        /// SpecimenExpirationDate
        /// </summary>
        public DateTime? SpecimenExpirationDate { get; set; }
        /// <summary>
        /// OrderedTest CprsOrderNumber
        /// </summary>
        public string CprsOrderNumber { get; set; }
        /// <summary>
        /// OrderedComponentCprsOrderNumber
        /// </summary>
        public string OrderedComponentCprsOrderNumber { get; set; }
        /// <summary>
        /// InterpText
        /// </summary>
        public override string InterpText
        {
            get
            {
                return "";
            }
        }
        /// <summary>
        /// WorkloadProcessID
        /// </summary>
        public override WorkloadProcessID WorkloadProcessId
        {
            get
            {
                return WorkloadProcessID.AutomatedSerologicCrossmatch;
            }
        }
        /// <summary>
        /// ISResult
        /// </summary>
        public PendingTestResultModel ISResult
        {
            get
            {
                var typeTypeList = new List<TestType>()
                {
                    TestType.XM_IS,
                    TestType.XMRepeat_IS
                };
                return GetPendingTestResult(typeTypeList, false);
            }
        }
        /// <summary>
        /// AHGInterp
        /// </summary>
        public PendingTestResultModel AHGResult
        {
            get
            {
                var typeTypeList = new List<TestType>()
                {
                    TestType.XM_AHG,
                    TestType.XMRepeat_AHG
                };
                return GetPendingTestResult(typeTypeList, false);
            }
        }
        /// <summary>
        /// ISInterp
        /// </summary>
        public PendingTestResultModel ISInterp
        {
            get
            {
                return GetPendingTestResult(TestType.IS_Interp, false);
            }
        }
        /// <summary>
        /// AHGInterp
        /// </summary>
        public PendingTestResultModel AHGInterp
        {
            get
            {
                return GetPendingTestResult(TestType.AHG_Interp, false);
            }
        }
        /// <summary>
        /// XMInterp
        /// </summary>
        public PendingTestResultModel XMInterp
        {
            get
            {
                var typeTypeList = new List<TestType>()
                {
                    TestType.XM_Interp,
                    TestType.XMRepeat_Interp
                };
                return GetPendingTestResult(typeTypeList, false);
            }
        }

        /// <summary>
        /// Validate Test
        /// </summary>
        public TestValidationModel Validate()
        {
            return Validate(BloodUnitModel);
        }

        /// <summary>
        /// Validate Test
        /// </summary>
        /// <param name="bloodUnitModel"></param>
        /// <returns></returns>
        public TestValidationModel Validate(BloodUnitModel bloodUnitModel)
        {
            return BOL.TestValidation.ValidateXM(
                        ISResult == null ? string.Empty : ISResult.TestResultId,
                        AHGResult == null ? string.Empty : AHGResult.TestResultId,
                        ISInterp == null ? string.Empty : ISInterp.TestResultId,
                        AHGInterp == null ? string.Empty : AHGInterp.TestResultId,
                        XMInterp == null ? string.Empty : XMInterp.TestResultId,
                        bloodUnitModel == null ? null : (Guid?)bloodUnitModel.BloodUnitGuid,
                        SpecimenExpirationDate);
        }

        /// <summary>
        /// Get user options for changing the XMInterp 
        /// </summary>
        /// <returns></returns>
        public IList<XMatchInterpOption> GetXMatchInterpOptions()
        {
            var optionList = new List<XMatchInterpOption>();

            if (XMInterp == null)
            {
                return optionList;
            }


            else if (XMInterp.TestResultId != PendingTestHelper.NOT_TESTED_SYMBOL)
            {
                optionList.Add(new XMatchInterpOption(XMInterp.TestResultId, XMInterp.TestResultText));
            }            

            if (XMInterp.TestResultId == PendingTestHelper.COMPATIBLE_DONT_TRANSFUSE_ID)
            {
                optionList.Add(new XMatchInterpOption(PendingTestHelper.COMPATIBLE_SAFE_TO_TRANSFUSE_ID,
                                                      "Compatible - Safe to Transfuse"));
            }
            else if (XMInterp.TestResultId == PendingTestHelper.COMPATIBLE_SAFE_TO_TRANSFUSE_ID)
            {
                optionList.Add(new XMatchInterpOption(PendingTestHelper.COMPATIBLE_DONT_TRANSFUSE_ID,
                                                      "Compatible - Dont Transfuse"));
            }
            else if (XMInterp.TestResultId == PendingTestHelper.INCOMPATIBLE)
            {
                optionList.Add(new XMatchInterpOption(PendingTestHelper.INCOMPATIBLE_ONLY_MEDICAL_DIRECTOR_ID,
                                                      "Incompatible - Only Medical Director"));
            }
            else if (XMInterp.TestResultId == PendingTestHelper.INCOMPATIBLE_ONLY_MEDICAL_DIRECTOR_ID)
            {
                optionList.Add(new XMatchInterpOption(PendingTestHelper.INCOMPATIBLE,
                                                      "Incompatible"));
            }

            return optionList;
        }
    }
}



